import { jsxs, Fragment, jsx } from "react/jsx-runtime";
import { T as TableFilter } from "./table-filter-BKvPriu7.js";
import { T as TableFooter } from "./table-footer-Cfva3_5Y.js";
import { T as TableHeader } from "./table-header-BdDXN7Km.js";
import { C as Card } from "./card-DBOrqCcU.js";
import { T as Table, a as TableBody, b as TableRow, c as TableCell } from "./table-Lb16Ctse.js";
import { D as DashboardLayout } from "./layout-Coo-00Zo.js";
import { useReactTable, getFilteredRowModel, getSortedRowModel, getCoreRowModel, flexRender } from "@tanstack/react-table";
import { useState } from "react";
import TableColumn from "./offline-table-columns-CQZhXRNG.js";
import VerifyPaymentModal from "./verify-payment-modal-BP0kaU1u.js";
import "./use-lang-44ndmTOc.js";
import "@inertiajs/react";
import "./debounce-ZFxqVthq.js";
import "./route-DlE7FdTW.js";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "lucide-react";
import "./button-CoRGprmX.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./table-page-size-CjbVFJnO.js";
import "./sidebar-4chFkdEZ.js";
import "./separator-BjFPAtSa.js";
import "@radix-ui/react-separator";
import "./sheet-BrIPI26w.js";
import "@radix-ui/react-dialog";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
import "./main-BlfvuptM.js";
import "./sonner-0gqP4YyH.js";
import "next-themes";
import "sonner";
import "./appearance-B5i6uI_j.js";
import "./language-pQjimNcB.js";
import "./notification-Bii6lhkq.js";
import "./popover-BomUxjap.js";
import "@radix-ui/react-popover";
import "date-fns";
import "./app-logo-CP8LgHIG.js";
import "./accordion-DjZKTuzo.js";
import "@radix-ui/react-accordion";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
import "./badge-CnqJovSa.js";
import "./alert-BKVD7z68.js";
import "./dialog-Bzzm0V8u.js";
import "./label-BKAgVFnB.js";
import "@radix-ui/react-label";
import "./textarea-M8ToDCeU.js";
import "richtor";
/* empty css                 */
const Offline = ({ payments, translate }) => {
  var _a;
  const { dashboard } = translate;
  const [selectedPayment, setSelectedPayment] = useState(null);
  const [isModalOpen, setIsModalOpen] = useState(false);
  const handleVerifyClick = (payment) => {
    setSelectedPayment(payment);
    setIsModalOpen(true);
  };
  const table = useReactTable({
    data: payments.data,
    columns: TableColumn(handleVerifyClick),
    getCoreRowModel: getCoreRowModel(),
    getSortedRowModel: getSortedRowModel(),
    getFilteredRowModel: getFilteredRowModel()
  });
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs(Card, { children: [
      /* @__PURE__ */ jsx(
        TableFilter,
        {
          data: payments,
          title: "Offline Payment Report",
          globalSearch: true,
          tablePageSizes: [10, 15, 20, 25, 50],
          routeName: "payment-reports.offline.index",
          className: "w-full"
        }
      ),
      /* @__PURE__ */ jsxs(Table, { className: "border-border border-y", children: [
        /* @__PURE__ */ jsx(TableHeader, { table }),
        /* @__PURE__ */ jsx(TableBody, { children: ((_a = table.getRowModel().rows) == null ? void 0 : _a.length) ? table.getRowModel().rows.map((row) => /* @__PURE__ */ jsx(TableRow, { "data-state": row.getIsSelected() && "selected", children: row.getVisibleCells().map((cell) => /* @__PURE__ */ jsx(TableCell, { children: flexRender(cell.column.columnDef.cell, cell.getContext()) }, cell.id)) }, row.id)) : /* @__PURE__ */ jsx(TableRow, { children: /* @__PURE__ */ jsx(TableCell, { colSpan: 8, className: "h-24 text-center", children: dashboard.no_results }) }) })
      ] }),
      /* @__PURE__ */ jsx(TableFooter, { className: "mt-1 p-5 sm:p-7", routeName: "payment-reports.offline.index", paginationInfo: payments })
    ] }),
    selectedPayment && /* @__PURE__ */ jsx(
      VerifyPaymentModal,
      {
        payment: selectedPayment,
        isOpen: isModalOpen,
        onClose: () => {
          setIsModalOpen(false);
          setSelectedPayment(null);
        }
      }
    )
  ] });
};
Offline.layout = (children) => /* @__PURE__ */ jsx(DashboardLayout, { children });
export {
  Offline as default
};
